function count = study_variations(VAR,name,count, allimmobiles,N_origtracks, Ext_global)
%  Histograms of number of motion variations and number of subtracks
%  VAR :   original analyzed track | % conf | % dir | % brow | % imm | nb of changes | duration in terms of subtracks | probability of change

% OUTPUT : analyses of mobile (including entierly brownian)  and motion-alternating tracks 

 
prob = 100.*VAR(:,8);
    prob_alter=prob;   
    subtr = VAR(:,7); 
    subtr_alter= subtr;
    nbchanges = VAR(:,6);
    nbchanges_alter=nbchanges;
    data=[nbchanges,subtr];
    
    index_imm = find(VAR(:,6)==0 & VAR(:,5)==1);   % tracks completely immobile
    index_brown = find(VAR(:,6)==0 & VAR(:,4)==1); % tracks completely brownian
    index_dir = find(VAR(:,6)==0 & VAR(:,3)==1); % tracks completely directed
    index_conf = find(VAR(:,6)==0 & VAR(:,2)==1); % tracks completely confined
    index_alter = vertcat(index_brown, index_dir, index_conf);
    
    pourcsuiteimm = numel(index_imm)/N_origtracks;
    ext_immimm = VAR(index_imm,9);

%     fig=figure(count);
%     edges=min(ext_immimm-.005):.01:max(ext_immimm+.005);
%     h1 = histogram(ext_immimm, edges,'Normalization','pdf', 'FaceColor','k')
%     axis on
%     xlabel({'Extents suites immobiles'})
%     ylabel({'Relative Frequency'})
%     namefile = ['./RESULTATS/' name '-ext-immimm-histo.eps'];
%     saveas(fig, namefile);
%     print('-depsc', namefile);
%     namefile2 = ['./RESULTATS/' name '-ext-immimm-histo'];
%     saveas(fig, namefile2, 'tif');
%     count=count+1;
%     
  
    %%%%%
    
  %  prob(index_imm)=[];
    prob_alter(index_alter)=[];
    
  %  subtr(index_imm)=[];
    subtr_alter(index_alter)=[];
    
  %  nbchanges(index_imm)=[];
    nbchanges_alter(index_alter)=[];
    
    VARbis=VAR;
    VAR_alter=VAR;
    
    % motion percentage for original mobile tracks
  %  VARbis(index_imm,:)=[];
   % pourcimmo = numel(index_imm)/size(VAR,1);
    pourcimmo = allimmobiles/N_origtracks;
    pourcdir = numel(find(VARbis(:,6)==0 & VARbis(:,3)==1))/N_origtracks;
    pourcconf = numel(find(VARbis(:,6)==0 & VARbis(:,2)==1))/N_origtracks;
    pourcbrow = numel(find(VARbis(:,6)==0 & VARbis(:,4)==1))/N_origtracks;
    
    % motion percentage for subtracks of alternating tracks
    VAR_alter(index_alter,:)=[];
    VAR_alter(:,2:5) = round(VAR_alter(:,2:5).*repmat(VAR_alter(:,7),1,4));
    perc_vardir= sum(VAR_alter(:,3))/sum(VAR_alter(:,7)) ;
    perc_varconf= sum(VAR_alter(:,2))/sum(VAR_alter(:,7));
    perc_varimmo=sum(VAR_alter(:,5))/sum(VAR_alter(:,7));
    perc_varbrow=sum(VAR_alter(:,4))/sum(VAR_alter(:,7));
    
  count=count+1;  
    
    % # Changes for mobile tracks 
    fig=figure(count);
    edges=[-.5:(max(nbchanges)+.5)];
    h = histogram(nbchanges,edges,'Normalization','pdf','FaceColor','k');
    xlabel('Number of motion variations in mobile tracks')
    ylabel('relative frequency')
    axis on
    param=100.*[pourcdir; pourcconf; pourcimmo; pourcbrow; pourcsuiteimm]; %percentage of motion for original tracks
    name_par = ['all-dir  '; 'all-conf '; 'all-imm  '; 'all-bro  '; 'imm-imm  '];
    S = [name_par,num2str(param)];
    descr={S};
    ax1 = axes('Position',[0 0 1 1],'Visible','off');
    axes(ax1) % sets ax1 to current axes
    text(.3,0.75,descr)
    namefile = ['./RESULTS/' name '-NbChanges-mob.eps'];
    saveas(fig, namefile);
    print('-depsc', namefile);
    count=count+1;
end
    
    
    % Prob change for mobile tracks
%     fig=figure(count);
%     edges=[floor(min(prob))-.5:ceil(max(prob))+.5];
%     h = histogram(prob,edges,'Normalization','pdf','FaceColor','k');
%     xlabel('Probability of motion variation in mobile tracks')
%     ylabel('relative frequency')
%     axis on
%     namefile = ['./RESULTATS/' name '-PROBchange-mob.eps'];
%     saveas(fig, namefile);
%     print('-depsc', namefile);
%     namefile2 = ['./RESULTATS/' name '-PROBchange-mob'];
%     saveas(fig, namefile2, 'tif');
%     count=count+1;
%     % Prob change for motion-alternating tracks
%     fig=figure(count);
%     edges=[floor(min(prob_alter))-.5:ceil(max(prob_alter))+.5];
%     h = histogram(prob_alter,edges,'Normalization','pdf','FaceColor','k');
%     xlabel('Probability of motion variation in alternating tracks')
%     ylabel('relative frequency')
%     axis on
%     namefile = ['./RESULTATS/' name '-PROBchange-alter.eps'];
%     saveas(fig, namefile);
%     print('-depsc', namefile);
%     namefile2 = ['./RESULTATS/' name '-PROBchange-alter'];
%     saveas(fig, namefile2, 'tif');
%     count=count+1;
%     
    % # Subtracks in mobile tracks
%     fig=figure(count);
%     edges=[min(subtr):max(subtr)];
%     h = histogram(subtr,max(subtr),'Normalization','pdf','FaceColor','k');
%     xlabel('Number of Subtracks in mobile tracks')
%     ylabel('relative frequency')
%     axis on
%     namefile = ['./RESULTATS/' name '-NbSubTr-mob.eps'];
%     saveas(fig, namefile);
%     print('-depsc', namefile);
%     namefile2 = ['./RESULTATS/' name '-NbSubTr-mob'];
%     saveas(fig, namefile2,'tif');
%     count=count+1; 
%     % # Subtracks in alternating tracks
%     fig=figure(count);
%     edges=[min(subtr_alter):max(subtr_alter)];
%     h = histogram(subtr_alter,max(subtr_alter),'Normalization','pdf','FaceColor','k');
%     xlabel('Number of Subtracks in alternating tracks')
%     ylabel('relative frequency')
%     axis on
%     namefile = ['./RESULTATS/' name '-NbSubTr-alter.eps'];
%     saveas(fig, namefile);
%     print('-depsc', namefile);
%     namefile2 = ['./RESULTATS/' name '-NbSubTr-alter'];
%     saveas(fig, namefile2, 'tif');
%   
    % # Changes for alternating tracks  
%     fig=figure(count);
%     edges=[-.5:(max(nbchanges_alter)+.5)];
%     h = histogram(nbchanges_alter,edges,'Normalization','pdf','FaceColor','k');
%     xlabel('Number of motion variations in alternating tracks')
%     ylabel('relative frequency')
%     axis on
%     param=100.*[perc_vardir; perc_varconf; perc_varimmo; perc_varbrow];  %percentage of motions for subtracks of motion-alternating tracks
%     name_par = ['var-sub-dir  '; 'var-sub-conf '; 'var-sub-imm  '; 'var-sub-bro  '];
%     S = [name_par,num2str(param)];
%     descr={S};
%     ax1 = axes('Position',[0 0 1 1],'Visible','off');
%     axes(ax1) % sets ax1 to current axes
%     text(.3,0.75,descr)
%     namefile = ['./RESULTATS/' name '-NbChanges-alter.eps'];
%     saveas(fig, namefile);
%     print('-depsc', namefile);
%     namefile2 = ['./RESULTATS/' name '-NbChanges-alter'];
%     saveas(fig, namefile2,'tif');
%     count=count+1;


